@
@ドーピングアイテムを60個単位にまとめます。
@ 0x5B 天使の衣 - 0x63 やせ薬 までの範囲を処理します.

.align 4
.macro blh to, reg=r3
  ldr \reg, =\to
  mov lr, \reg
  .short 0xf800
.endm


.thumb
	push	{r4,r5,r6, lr}
	sub sp, #0x4 * 9  @合計値を保存する

	@合計を求めるためゼロクリア
	mov r0, sp
	mov r1, #0x0
	mov r2, #0x4 * 9
	blh 0x080d6968   @memset	{J}

	@輸送隊アドレスの取得
	ldr		r0, =0x08031470	@{J}
@	ldr		r0, =0x08031524	@{U}
	ldr		r2, [r0]       @輸送隊アドレス
	ldrb	r3, [r0,#0x4]  @最大個数

	@ループ上限 = 開始アドレス+(個数*2バイト)
	lsl		r3,r3,#0x1	@r3 * 2
	add		r6,r3,r2	@終端

	@輸送隊アドレス
	mov		r5,r2

	@輸送隊書き込みアドレス
	@アイテムを没収する場合、余白ができるので詰めていく
	mov		r4,r2

yusotai_loop:
	ldrb	r0,[r5,#0x0] @アイテムID
	ldrb	r1,[r5,#0x1] @個数
	add		r5,#0x2		@アイテムID 個数の2バイト配列のため

	cmp		r0,#0x5B    @天使の衣
	blt		yusotai_loop_non
	cmp		r0,#0x63    @やせ薬
	bgt		yusotai_loop_non
	
	@ターゲットのドーピングアイテム
yusotai_item_pickup:
	mov		r2,#0x5B
	sub		r0,r2      @天使の衣をindex0にしたい.
	lsl		r0,#2      @ *4
	mov		r3,sp
	ldr		r2,[r3,r0] @countArray[item_id - 0x5B] += item_count
	add		r2,r1
	str		r2,[r3,r0]

	b		yusotai_next

yusotai_loop_non:
	cmp		r0,#0x00     @アイテム終端
	beq		yusotai_item_zeropadding

	@特定のアイテム以外はコピーする
	strb	r0,[r4,#0x0]
	strb	r1,[r4,#0x1]
	add		r4,#0x2

yusotai_next:
	cmp		r5,r6
	blt		yusotai_loop		@上限アドレスを超えていれなければ続く

yusotai_item_zeropadding:
@	@輸送隊は、ゼロ終端ではない。
	@特効薬を売って余白ができていた場合、
	@輸送隊欄に余白ができないように0で埋めないとダメ。
	cmp		r6,r4
	ble		yusotai_end

	mov		r0,#0x00
	strb	r0,[r4,#0x0]
	strb	r0,[r4,#0x1]
	add		r4,r4,#0x2
	b		yusotai_item_zeropadding

yusotai_end:


@個別キャラの持ち物スタート
	ldr		r5, =0x0202BE48	@{J}
@	ldr		r5, =0x0202BE4C	@{U}

character_loop:
	ldrh	r0,[r5]

	mov		r1,#0x00
	cmp		r0,r1
	beq		character_end

	add		r5,#0x1E	@アイテム1 アイテムIDへ
	mov		r4,r5		@書込
	
	mov		r6,r5		@個数5つまでループする
	add		r6,#0xA		@5個*2バイト = 0xA
item_loop:
	ldrb	r0,[r5,#0x00]	@アイテムID
	ldrb	r1,[r5,#0x01]	@アイテム個数
	add		r5,#0x2

	cmp		r0,#0x5B    @天使の衣
	blt		character_item_non
	cmp		r0,#0x63    @やせ薬
	bgt		character_item_non

	@ターゲットのドーピングアイテム
character_item_pickup:
	mov		r2,#0x5B
	sub		r0,r2      @天使の衣をindex0にしたい.
	lsl		r0,#2      @ *4
	mov		r3,sp
	ldr		r2,[r3,r0] @countArray[item_id - 0x5B] += item_count
	add		r2,r1
	str		r2,[r3,r0]

	b		character_item_next

character_item_non:
	cmp		r0,#0x00     @アイテム終端
	beq		character_item_zeropadding

	@特定のアイテム以外はコピーする
	strb	r0,[r4,#0x0]
	strb	r1,[r4,#0x1]
	add		r4,#0x2			@アイテムID 個数の2バイト配列のため

character_item_next:
	cmp		r5,r6
	blt		item_loop		@アイテム5を処理するまでループ

character_item_zeropadding:
	@アイテム欄も、ゼロ終端ではない。
	@特効薬を売って余白ができていた場合、
	@5つのアイテム欄に余白ができないように0で埋めないとダメ。
	cmp		r6,r4
	ble		character_next

	mov		r0,#0x00
	strb	r0,[r4,#0x0]
	strb	r0,[r4,#0x1]
	add		r4,r4,#0x2
	b		character_item_zeropadding

character_next:

	mov		r5, #0x20	@次の人へ #0x48 - (#0xA + #0x1E) = 0x20
	add		r5,r5, r6
	b		character_loop

character_end:

	@60個数ごとにドーピングアイテムを配置していきます。(アイテムの上限は63個なので)
	mov r5, sp
	mov r4, #0x5B    @天使の衣

redistribution_loop:
	cmp r4, #0x63    @やせ薬
	bgt exit_return
	
	mov r0, r4       @ItemID
	ldr r1, [r5]     @TotalCount
	bl  RunRedistribution

	add r4, #0x1
	add r5, #0x4
	b   redistribution_loop

exit_return:
	mov	r0, #0

	add sp, #0x4 * 9
	pop	{pc, r6 , r5 ,r4 }


@r0       @ItemID
@r1       @TotalCount
RunRedistribution:
	push	{lr,r4,r5}
	
	mov r4, r0 @ItemID
	mov r5, r1 @TotalCount

	cmp r5, #60
	ble RunRedistributionLast

	@60個の塊として登録する.
	mov r0, r4 @ItemID
	mov r1, #60 @Count
	bl  PushItem

	mov r0, #60
	sub r5, r5, r0

RunRedistributionLast:
	cmp r5, #0x0
	beq RunRedistributionExit

	@端数
	mov r0, r4 @ItemID
	mov r1, r5 @Count
	bl  PushItem

RunRedistributionExit:

	pop		{r4,r5}
	pop		{r0}
	bx r0

@r0       @ItemID
@r1       @TotalCount
PushItem:
	push	{lr,r4,r5,r6,r7}
	lsl		r1,r1,#0x8	@売値を求める関数は 引数r0に 以下のようにセットしなければいけない。
	add		r0,r0,r1	@個数 << 8 + アイテムID 例:レイピア60個  0x3c09 3c=60 09=レイピアのアイテムID
	mov		r7, r0      @PackedItem

	@まず、輸送隊へ送れるか検討する
	@輸送隊アドレスの取得
	ldr		r0, =0x08031470	@{J}
@	ldr		r0, =0x08031524	@{U}
	ldr		r2, [r0]       @輸送隊アドレス
	ldrb	r3, [r0,#0x4]  @最大個数

	@ループ上限 = 開始アドレス+(個数*2バイト)
	lsl		r3,r3,#0x1	@r3 * 2
	add		r6,r3,r2	@終端

	@輸送隊アドレス
	mov		r5,r2

PushItem_yusotai_loop:
	ldrb	r0,[r5,#0x0] @アイテムID
	cmp		r0,#0x00     @アイテム終端
	bne		PushItem_yusotai_next

PushItem_yusotai_item_write:
	strh	r7,[r5]      @輸送隊の終端に書き込む
	b		PushItem_Exit

PushItem_yusotai_next:
	add		r5,#0x2
	cmp		r5,r6
	blt		PushItem_yusotai_loop		@上限アドレスを超えていれなければ続く

@輸送隊が満杯だった!
@仕方ないので、ユニットに持たせる.

@個別キャラの持ち物スタート
	ldr		r5, =0x0202BE48	@{J}
@	ldr		r5, =0x0202BE4C	@{U}

PushItem_character_loop:
	ldrh	r0,[r5]

	mov		r1,#0x00
	cmp		r0,r1
	beq		PushItem_character_end
	
	@死亡や離脱している人には、渡すと消えてしまうので除外する。
	ldr		r1,[r5, #0xC]
	mov		r0, #0x4	@Dead 戦死
	and		r0, r1
	bne		PushItem_character_next

	lsl		r0, r1, #0xF	@Escape 離脱
	bmi		PushItem_character_next


	add		r5,#0x1E	@アイテム1 アイテムIDへ
	mov		r4,r5		@書込
	
	mov		r6,r5		@個数5つまでループする
	add		r6,#0xA		@5個*2バイト = 0xA
PushItem_item_loop:
	ldrb	r0,[r5,#0x00]	@アイテムID
	cmp		r0, #0x0
	bne		PushItem_character_item_next

PushItem_item_write:
	strh	r7,[r5]      @ユニットの持ち物の余白に書き込む
	b		PushItem_Exit

PushItem_character_item_next:
	add		r5,#0x2
	cmp		r5,r6
	blt		PushItem_item_loop		@アイテム5を処理するまでループ

PushItem_character_next:

	mov		r5, #0x20	@次の人へ #0x48 - (#0xA + #0x1E) = 0x20
	add		r5,r5, r6
	b		PushItem_character_loop

PushItem_character_end:
	@アイテムロスト 通常はありえない

PushItem_Exit:

	pop		{r4,r5,r6,r7}
	pop		{r0}
	bx r0

