@install ORG 0xCADA0
.thumb
.macro blh to, reg=r3
  ldr \reg, =\to
  mov lr, \reg
  .short 0xf800
.endm

push {r4,r5,r6,r7,lr}
mov r4 ,r0

@ターン数の取得
ldr r0, =0x0202BCEC	@ChatperInfo {J}
ldrb r7, [r0, #0x10]

@マップAddrの取得
ldr r0, =0x0202BCEC	@ChatperInfo {J}
ldrb r0, [r0, #0xE]
blh 0x08034520	@GetROMChapterStruct
mov r5, r0

ldr r6, =0x0201F148	@Soundroom buffer	{J}

mov r1, #0x2d
ldrb r0, [r5,r1]
cmp r0, #0x0
beq NoRank

mov r1, #0x2d
ldrb r0, [r5,r1]
cmp r7, r0
ble RankA

mov r1, #0x31
ldrb r0, [r5,r1]
cmp r7, r0
ble RankB

mov r1, #0x35
ldrb r0, [r5,r1]
cmp r7, r0
ble RankC

mov r1, #0x39
ldrb r0, [r5,r1]
cmp r7, r0
ble RankD

RankE:
ldr r0, =0x1354	@現在のターン数です。残念ながら、Ｄ判定すらもう無理ですが、頑張ってクリアを目指しましょう。
bl strcat

b   Exit

NoRank:
mov r7, r0
ldr r0, =0x135C	@このマップにはターン評価はありません。
bl strcat
b   Exit

RankA:
mov r7, r0
ldr r0, =0x675	@現在のターン数です。
bl strcat

bl InsterTurn

ldr r0, =0x135B	@ターン以内にクリアすればＡ判定です。頑張ってください。
bl strcat
b   Exit

RankB:
mov r7, r0
ldr r0, =0x1359	@残念ながら、Ａ判定はもう無理ですが、
bl strcat

bl InsterTurn

ldr r0, =0x135A	@ターン以内にクリアすればＢ判定です。
bl strcat
b   Exit

RankC:
mov r7, r0
ldr r0, =0x1357	@残念ながら、Ｂ判定はもう無理ですが、
bl strcat

bl InsterTurn

ldr r0, =0x1358	@ターン以内にクリアすればＣ判定です。
bl strcat
b   Exit

RankD:
mov r7, r0
ldr r0, =0x1355	@残念ながら、Ｃ判定はもう無理ですが、
bl strcat

bl InsterTurn

ldr r0, =0x1356	@ターン以内にクリアすればＤ判定です。
bl strcat
@b   Exit

Exit:
@曲名を所定の位置にセット
mov r1 ,r4
add r1, #0x4c
mov  r0, #0x45   @RAMバッファを表示する用に仕込んでおいたTextID 0x45
strh r0, [r1, #0x0]

pop {r4,r5,r6,r7}
pop {r0}
bx r0


strcat:	@r0=textID
push {lr}
mov r1, r6
blh 0x08009fe4   @GetStringFromIndexInBuffer	{J}

mov r0, r6
blh 0x080d6a08   @strlen	{J}
add r6, r0
pop {r1}
bx  r1


InsterTurn:
push {lr}
mov r0, r7
mov r1, r6
blh 0x08014328 @SomeDrawNumber	{J}
mov r0, r6
blh 0x080d6a08   @strlen	{J}
add r6, r0
pop {r1}
bx  r1
