;
;輸送隊とキャラクタの持ち物をスキャンして、特効薬を探して、
;売値を @0080@0005 で取得できる領域に書き込み、
;売るものがあるかどうかで条件フラグを変化させる
;
@org	$08E4FB90
@thumb
	push	{r4,r5,r6,r7, lr}

	;トータルの売値を格納する
	mov		r7,0

	;輸送隊アドレスの取得
	ldr		r0, =$08031470
	ldr		r2, [r0]       ;輸送隊アドレス
	ldrb	r3, [r0,#0x4]  ;最大個数

	;ループ上限 = 開始アドレス+(個数*2バイト)
	lsl		r3,r3,#0x1	;r3 * 2
	add		r6,r3,r2	;終端

	;輸送隊アドレス
	mov		r5,r2

;#IFDEF SELL
;	;輸送隊書き込みアドレス
;	;アイテムを没収する場合、余白ができるので詰めていく
;	mov		r4,r2
;#ENDIF SELL

yusotai_loop
	ldrb	r0,[r5,#0x0] ;アイテムID
	ldrb	r1,[r5,#0x1] ;個数
	add		r5,#0x2		;アイテムID 個数の2バイト配列のため

	cmp		r0,#0x6C
	beq		yusotai_item_pickup
	cmp		r0,#0x6D
	beq		yusotai_item_pickup

	cmp		r0,#0x00     ;アイテム終端
	beq		yusotai_item_zeropadding

;#IFDEF SELL
;	;特定のアイテム以外はコピーする
;	strb	r0,[r4,#0x0]
;	strb	r1,[r4,#0x1]
;	add		r4,#0x2
;#ENDIF SELL

	b		yusotai_next

yusotai_item_pickup
	;売値を求める
	lsl		r1,r1,#0x8	;売値を求める関数は 引数r0に 以下のようにセットしなければいけない。
	add		r0,r0,r1	;個数 << 8 + アイテムID 例:レイピア60個  0x3c09 3c=60 09=レイピアのアイテムID
						;戻り値はr0に売値が返ってくる.
						;この関数はr1,r2,r3を破壊する
	
	ldr		r1,=$080B9DEC
	mov		lr, r1
	@dcw	$F800

	add		r7,r7,r0	;累積売値

yusotai_next
	cmp		r5,r6
	blt		yusotai_loop		;上限アドレスを超えていれなければ続く

yusotai_item_zeropadding
;#IFDEF SELL
;;	;輸送隊は、ゼロ終端ではない。
;	;特効薬を売って余白ができていた場合、
;	;輸送隊欄に余白ができないように0で埋めないとダメ。
;	cmp		r6,r4
;	ble		yusotai_end
;
;	mov		r0,0x00
;	strb	r0,[r4,#0x0]
;	strb	r0,[r4,#0x1]
;	add		r4,r4,#0x2
;	b		yusotai_item_zeropadding
;#ENDIF SELL

yusotai_end


;個別キャラの持ち物スタート
	ldr		r5, =$0202BE48

character_loop
	ldrh	r0,[r5]

	mov		r1,#0x00
	cmp		r0,r1
	beq		character_end

	add		r5,#0x1E	;アイテム1 アイテムIDへ
;#IFDEF SELL
;	mov		r4,r5		;書込
;#ENDIF SELL
	
	mov		r6,r5		;個数5つまでループする
	add		r6,#0xA		;5個*2バイト = 0xA
item_loop
	ldrb	r0,[r5,#0x00]	;アイテムID
	ldrb	r1,[r5,#0x01]	;アイテム個数
	add		r5,#0x2
	
	cmp		r0,#0x6C
	beq		character_item_pickup
	cmp		r0,#0x6D
	beq		character_item_pickup

	cmp		r0,#0x00     ;アイテム終端
	beq		character_item_zeropadding

;#IFDEF SELL
;	;特定のアイテム以外はコピーする
;	strb	r0,[r4,#0x0]
;	strb	r1,[r4,#0x1]
;	add		r4,#0x2			;アイテムID 個数の2バイト配列のため
;#ENDIF SELL

	b		character_item_next

character_item_pickup
	;売値を求める
	lsl		r1,r1,#0x8	;売値を求める関数は 引数r0に 以下のようにセットしなければいけない。
	add		r0,r0,r1	;個数 << 8 + アイテムID 例:レイピア60個  0x3c09 3c=60 09=レイピアのアイテムID
						;戻り値はr0に売値が返ってくる.
						;この関数はr1,r2,r3を破壊する
	
	ldr		r1,=$080B9DEC
	mov		lr, r1
	@dcw	$F800

	add		r7,r7,r0	;累積売値

character_item_next
	cmp		r5,r6
	blt		item_loop		;アイテム5を処理するまでループ

character_item_zeropadding
;#IFDEF SELL
;	;アイテム欄も、ゼロ終端ではない。
;	;特効薬を売って余白ができていた場合、
;	;5つのアイテム欄に余白ができないように0で埋めないとダメ。
;	cmp		r6,r4
;	ble		character_next
;
;	mov		r0,0x00
;	strb	r0,[r4,#0x0]
;	strb	r0,[r4,#0x1]
;	add		r4,r4,#0x2
;	b		character_item_zeropadding
;#ENDIF SELL

character_next

	mov		r5, #0x20	;次の人へ #0x48 - (#0xA + #0x1E) = 0x20
	add		r5,r5, r6
	b		character_loop

character_end

;#IFDEF SELL
;	;所持金を加算する
;	ldr	r2, =$0202BCF4	;所持金を取得
;	ldr	r0, [r2]
;	add	r0,r0,r7			;所持金を加算
;	ldr	 r1,=$000F423F	;MAX999999ゴールド
;	cmp r0,r1			;所持金が 999999ゴールドを超えるか？
;	blt gold_append
;	mov r0,r1			;超えるなら補正
;gold_append
;	str	r0, [r2]		;所持金の書き込み
;#ENDIF SELL

	;売値のゴールドを @0080@0005で取れるように書き込む
	;注意:@0080@0005は会話でしか取れない。システムメッセージでは読めないらしい
	mov		r0,r7
	ldr		r1,=$08008914
	mov		lr, r1
	@dcw	$F800

	;イベント命令の条件式でぜひが取れるようにする
	ldr	r2, =$030004B0  ; + #0x30
	mov	r0, #0
	cmp r7,#0x0		;売るものがあるかどうか判定
	beq not_sell
	mov	r0, #1		;売るものがある
not_sell
	str	r0, [r2, #0x30]	;条件式で取れる領域に書き込む
						;400CXX00 0C000000	未達成ならジャンプ  / ;410CXX00 0C000000	達成ならジャンプ

exit_return

	pop	{pc,r7, r6 , r5 ,r4 }
